/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vconevnt;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vconevnt.ChangeTimeBean;
import com.ibm.hwmca.base.vconevnt.ViewConsoleEventsBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;

public class ViewConsoleEventsTasklet
extends PanelTasklet {
    private static final String TRACE_MASKT = "HVCETSKT";
    private static final String TRACE_MASKF = "HVCETSKF";
    private static final String TRACE_MASKD = "HVCETSKD";
    private static final String LISTBEAN = "ListBean";
    private static final String TIMEBEAN = "TimeBean";
    private static DateFormat _dateFormat;
    private static DateFormat _timeFormat;
    private static Locale loc;

    public void init() {
        Trace.trace(TRACE_MASKD, " in init in EventLogInitTable()");
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null) {
            loc = userContext.getLocale();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        _dateFormat = DateTimePattern.getDatePattern(loc);
        _dateFormat.setTimeZone(userContext.getTimeZone());
        _timeFormat = DateTimePattern.getTimeWithMillisecondsPattern(loc);
        _timeFormat.setTimeZone(userContext.getTimeZone());
        Trace.trace(TRACE_MASKD, " out init in EventLogInitTable()");
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKT, ">> service: isInitialRequest()");
            try {
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "vconevent.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "vconevent.busy.text"));
                ViewConsoleEventsBean databean = new ViewConsoleEventsBean();
                databean.setBeanName(LISTBEAN);
                Log[] events = Log.retrieve(new Byte[]{new Byte(0)}, null, null, null, null);
                if (events != null) {
                    Trace.trace(TRACE_MASKT, "service: events.length = " + events.length);
                    String[][] eventData = new String[events.length][4];
                    for (int i = 0; i < events.length; ++i) {
                        eventData[i][0] = _dateFormat.format(events[i].getTimestamp());
                        eventData[i][1] = _timeFormat.format(events[i].getTimestamp());
                        try {
                            eventData[i][2] = new SystemEventLog(events[i]).getEventText().toString(loc);
                        }
                        catch (MissingResourceException e) {
                            Trace.trace(TRACE_MASKT, "service: Missing resource exception" + e);
                            eventData[i][2] = "";
                        }
                        eventData[i][3] = new Long(events[i].getTimestamp().getTime()).toString();
                    }
                    databean.setItemDescriptorInfo(eventData);
                } else {
                    Trace.trace(TRACE_MASKT, "service: events array is null");
                    databean.setItemDescriptorInfo(null);
                }
                this.destroyBusyDialog();
                response.replace("com.ibm.hwmca.base.vconevnt.res.ViewConsoleEventsRes", "ViewConsoleEventsPanel", databean);
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "service: " + e);
                response.noAction();
            }
            Trace.trace(TRACE_MASKT, "<< service: isInitialRequest()");
        } else if (request.isDisposed()) {
            Trace.trace(TRACE_MASKT, ">> service: isDisposed()");
            response.dispose();
        } else {
            String action = (String)request.getData("action");
            if (action != null) {
                Trace.trace(TRACE_MASKT, ">>>TASKLET>>> service: action = " + action);
                if (action.equals("newendtime")) {
                    response.update(LISTBEAN, (Calendar[])request.getData("newendData"));
                } else {
                    response.noAction();
                }
            } else {
                TaskActionEvent event = (TaskActionEvent)request.getData("event");
                String eventname = event == null ? (String)request.getData("menuevent") : event.getElementName();
                Trace.trace(TRACE_MASKT, ">>>TASKLET>>> service: eventname = " + eventname);
                if (eventname.equals("SaveButton")) {
                    Trace.trace(TRACE_MASKT, "service: SaveButton event");
                } else if (eventname.equals("CancelButton")) {
                    Trace.trace(TRACE_MASKT, "service: CancelButton event");
                } else if (eventname.equals("ViewMenu.ExitItem")) {
                    Trace.trace(TRACE_MASKT, "service: ExitItem event");
                } else if (eventname.equals("ViewMenu.UsingDifferentTimeRangeItem")) {
                    ChangeTimeBean changeTimeBean = new ChangeTimeBean((String[])request.getData("startendData"), (String[])request.getData("startendrefreshData"));
                    changeTimeBean.setBeanName(TIMEBEAN);
                    response.openModalChild("com.ibm.hwmca.base.vconevnt.res.ViewConsoleEventsRes", "ChangeTimePanel", changeTimeBean);
                } else if (eventname.equals("RefreshButton") || eventname.equals("OKButton")) {
                    Trace.trace(TRACE_MASKT, "service: Before Update");
                    PanelTaskletRequest selfRequest = new PanelTaskletRequest();
                    selfRequest.setData("event", event);
                    selfRequest.setData("newendData", (Calendar[])request.getData("newendData"));
                    selfRequest.setData("action", "newendtime");
                    this.postRequest(LISTBEAN, selfRequest);
                    response.dispose(TIMEBEAN);
                } else {
                    response.terminate();
                }
            }
        }
    }
}

